;;; ------------------------------------------------------------
;;;  TEXTIMPORT - Version 2.0 (Replace mode)
;;;  Entwickelt als zweite Version (Ersetzen statt Ergaenzen)
;;;
;;;  Diese Version ersetzt direkt:
;;;    - TEXT      -> TextString
;;;    - MTEXT     -> TextString
;;;    - MLEADER   -> TextString
;;;
;;;  Keine zusaetzlichen Layer.
;;;  Keine Overlay-Objekte.
;;;  CSV-Struktur wie beim Export:
;;;    ID;SpaceType;LayoutName;EntityType;BlockName;AttrTag;Text;Uebersetzung
;;; ------------------------------------------------------------

(vl-load-com)

(defun td2:csv-split (s / lst pos)
  (setq lst '())
  (while (setq pos (vl-string-search ";" s))
    (setq lst (append lst (list (substr s 1 pos))))
    (setq s   (substr s (+ pos 2)))
  )
  (append lst (list s))
)

(defun td2:trim (s /)
  (if (null s) (setq s ""))
  (while (and (> (strlen s) 0)
              (member (substr s 1 1) '(" " "\t")))
    (setq s (substr s 2)))
  (while (and (> (strlen s) 0)
              (member (substr s (strlen s) 1) '(" " "\t")))
    (setq s (substr s 1 (1- (strlen s)))))
  s
)

(defun c:TEXTIMPORT
  (/ filename f line cols id-str ue-text trans-alist
     doc layouts lay layName btr obj oname id attList pair)

  (vl-load-com)

  (prompt "\nTEXTIMPORT Version 2.0 - Replace mode\n")

  ;; CSV-Datei waehlen
  (setq filename (getfiled "CSV mit Uebersetzungen waehlen" "" "csv" 0))
  (if (not filename)
    (progn (prompt "\nAbbruch.") (princ))
    (progn

      ;; Datei oeffnen
      (setq f (open filename "r"))
      (if (null f)
        (progn (prompt "\nFehler: Datei konnte nicht geoeffnet werden.") (princ))
        (progn

          ;; Kopf ueberspringen
          (setq line (read-line f))
          (setq trans-alist '())

          ;; CSV lesen
          (while (setq line (read-line f))
            (setq cols    (td2:csv-split line))
            (setq id-str  (td2:trim (nth 0 cols)))
            (setq ue-text (td2:trim (nth 7 cols)))  ;; Spalte H

            (if (and ue-text (/= ue-text ""))
              (setq trans-alist (cons (cons id-str ue-text) trans-alist))
            )
          )
          (close f)

          (if (null trans-alist)
            (progn (prompt "\nKeine Uebersetzungen gefunden.") (princ))
            (progn

              (setq doc (vla-get-ActiveDocument (vlax-get-Acad-Object)))
              (setq layouts (vla-get-Layouts doc))
              (setq id 0)

              (prompt
                (strcat
                  "\nStarte TEXTIMPORT Version 2.0 - "
                  (itoa (length trans-alist))
                  " Uebersetzungen gefunden...\n"
                )
              )

              ;; gleiche Struktur wie beim Export
              (vlax-for lay layouts
                (setq layName (vla-get-Name lay)
                      btr     (vla-get-Block lay)
                )

                (vlax-for obj btr
                  (setq oname (vla-get-ObjectName obj))

                  (cond

                    ;; TEXT -----------------------------------------
                    ((= oname "AcDbText")
                     (setq id (1+ id))
                     (setq pair (assoc (itoa id) trans-alist))
                     (if pair
                       (vla-put-TextString obj (cdr pair))
                     )
                    )

                    ;; MTEXT ----------------------------------------
                    ((= oname "AcDbMText")
                     (setq id (1+ id))
                     (setq pair (assoc (itoa id) trans-alist))
                     (if pair
                       (vla-put-TextString obj (cdr pair))
                     )
                    )

                    ;; MLEADER --------------------------------------
                    ((= oname "AcDbMLeader")
                     (setq id (1+ id))
                     (setq pair (assoc (itoa id) trans-alist))
                     (if pair
                       (vla-put-TextString obj (cdr pair))
                     )
                    )

                    ;; ATTRIBUTES – nur weiterzaehlen --------------
                    ((= oname "AcDbBlockReference")
                     (if (= (vla-get-HasAttributes obj) :vlax-true)
                       (progn
                         (setq attList
                           (vlax-safearray->list
                             (vlax-variant-value
                               (vla-GetAttributes obj)
                             )
                           )
                         )
                         (foreach att attList
                           (setq id (1+ id))
                         )
                       )
                     )
                    )

                    ;; andere ignorieren ----------------------------
                  )
                )
              )

              (prompt "\nTEXTIMPORT Version 2.0 abgeschlossen.\n")
            )
          )
        )
      )
    )
  )

  (princ)
)
